/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.vistara.sdk.utils.APIConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkUtil
implements APIConstants {
    private static Logger logger = LoggerFactory.getLogger(SdkUtil.class);
    private static SdkUtil _instance = null;
    private static ObjectMapper objectMapper = null;
    private String apiKey = null;
    private String apiSecret = null;
    private String apiUserName = null;
    private String apiPassword = null;
    private String authType = null;
    private String accessToken = null;
    private String apiBaseURI = null;
    private int connectTimeout = -1;
    private int connectionRequestTimeout = -1;
    private int socketTimeout = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SdkUtil getInstance() {
        if (_instance != null) return _instance;
        Class<SdkUtil> clazz = SdkUtil.class;
        synchronized (SdkUtil.class) {
            if (_instance != null) return _instance;
            _instance = new SdkUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public String postRequest(String url, String jsonPayload) throws Exception {
        String response = null;
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        HttpPost httpMethod = new HttpPost(url);
        this.setMethodHeaders(httpMethod);
        StringEntity entity = new StringEntity(jsonPayload.toString(), "UTF-8");
        httpMethod.setEntity(entity);
        response = this.handleHttpMethod(httpMethod);
        if (response != null && response.contains("access token expired")) {
            this.generateAccessToken();
            httpMethod.removeHeaders("Authorization");
            httpMethod.setHeader("Authorization", "bearer " + this.accessToken);
            response = this.handleHttpMethod(httpMethod);
        }
        return response;
    }

    public String postRequest(String url, Object object) throws Exception {
        String response = null;
        if (null == object) {
            throw new Exception("Object to post request cannot be null");
        }
        String jsonPayload = objectMapper.writeValueAsString(object);
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("Failed to convert from object to json");
        }
        response = this.postRequest(url, jsonPayload);
        return response;
    }

    public String putRequest(String url) throws Exception {
        String response = null;
        try {
            HttpPut httpMethod = new HttpPut(url);
            this.setMethodHeaders(httpMethod);
            response = this.handleHttpMethod(httpMethod);
            if (response != null && response.contains("access token expired")) {
                this.generateAccessToken();
                httpMethod.removeHeaders("Authorization");
                httpMethod.setHeader("Authorization", "bearer " + this.accessToken);
                response = this.handleHttpMethod(httpMethod);
            }
            return response;
        }
        catch (Exception e) {
            throw new Exception("Failed to POST data to Vistara, Reson :" + e.getMessage());
        }
    }

    public String putRequest(String url, String jsonPayload) throws Exception {
        String response = null;
        try {
            HttpPut httpMethod = new HttpPut(url);
            this.setMethodHeaders(httpMethod);
            StringEntity entity = new StringEntity(jsonPayload.toString(), "UTF-8");
            httpMethod.setEntity(entity);
            response = this.handleHttpMethod(httpMethod);
            if (response != null && response.contains("access token expired")) {
                this.generateAccessToken();
                httpMethod.removeHeaders("Authorization");
                httpMethod.setHeader("Authorization", "bearer " + this.accessToken);
                response = this.handleHttpMethod(httpMethod);
            }
            return response;
        }
        catch (Exception e) {
            throw new Exception("Failed to POST data to Vistara, Reson :" + e.getMessage());
        }
    }

    public String getRequest(String url) throws Exception {
        String response = null;
        logger.error(url);
        HttpGet httpMethod = new HttpGet(url);
        this.setMethodHeaders(httpMethod);
        response = this.handleHttpMethod(httpMethod);
        if (response != null && response.contains("access token expired")) {
            this.generateAccessToken();
            httpMethod.removeHeaders("Authorization");
            httpMethod.setHeader("Authorization", "bearer " + this.accessToken);
            response = this.handleHttpMethod(httpMethod);
        }
        return response;
    }

    public HttpResponse getRequest(String url, Map<String, String> headers) throws Exception {
        logger.error(url);
        HttpGet httpMethod = new HttpGet(url);
        this.setMethodHeaders(httpMethod);
        if (headers != null && !headers.isEmpty()) {
            this.setAdditionalMethodHeaders(httpMethod, headers);
        }
        return this.handleHttpMethod2(httpMethod);
    }

    public String deleteRequest(String url) throws Exception {
        String response = null;
        HttpDelete httpMethod = new HttpDelete(url);
        this.setMethodHeaders(httpMethod);
        response = this.handleHttpMethod(httpMethod);
        if (response != null && response.contains("access token expired")) {
            this.generateAccessToken();
            httpMethod.removeHeaders("Authorization");
            httpMethod.setHeader("Authorization", "bearer " + this.accessToken);
            response = this.handleHttpMethod(httpMethod);
        }
        return response;
    }

    private void setMethodHeaders(HttpRequestBase httpMethod) throws Exception {
        if (httpMethod instanceof HttpPost || httpMethod instanceof HttpPut) {
            httpMethod.setHeader("Content-Type", "application/json");
        }
        httpMethod.setHeader("Accept", "application/json");
        switch (this.authType) {
            case "Oauth2": {
                if (this.accessToken == null || this.accessToken.isEmpty()) {
                    this.generateAccessToken();
                }
                httpMethod.setHeader("Authorization", "bearer " + this.accessToken);
                break;
            }
            case "Webhook": {
                httpMethod.setHeader("Authorization", "vtoken " + this.accessToken);
                break;
            }
            case "Basic": {
                httpMethod.setHeader("Authorization", this.getAuthorizationHeaderForBasic(this.apiUserName, this.apiPassword));
                break;
            }
        }
    }

    private void setAdditionalMethodHeaders(HttpRequestBase httpMethod, Map<String, String> headers) throws Exception {
        if (httpMethod == null) {
            return;
        }
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            httpMethod.removeHeaders(header.getKey());
            httpMethod.setHeader(header.getKey(), header.getValue());
        }
    }

    private String handleHttpMethod(HttpRequestBase httpMethod) throws Exception {
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient httpclient = builder.build();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.getConnectTimeout()).setConnectionRequestTimeout(this.getConnectionRequestTimeout()).setSocketTimeout(this.getSocketTimeout()).build();
        builder.setDefaultRequestConfig(config).build();
        CloseableHttpResponse httpResponse = null;
        try {
            httpclient = SdkUtil.wrapClient(builder);
            SdkUtil.trustSelfSignedSSL();
            httpResponse = httpclient.execute(httpMethod);
            String string = this.parseResponse(httpResponse);
            return string;
        }
        catch (Exception e) {
            throw new Exception("Failed to send http request, Reason: " + e);
        }
        finally {
            httpclient.close();
        }
    }

    private HttpResponse handleHttpMethod2(HttpRequestBase httpMethod) throws Exception {
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient httpclient = builder.build();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.getConnectTimeout()).setConnectionRequestTimeout(this.getConnectionRequestTimeout()).setSocketTimeout(this.getSocketTimeout()).build();
        builder.setDefaultRequestConfig(config).build();
        CloseableHttpResponse httpResponse = null;
        try {
            httpclient = SdkUtil.wrapClient(builder);
            SdkUtil.trustSelfSignedSSL();
            CloseableHttpResponse closeableHttpResponse = httpResponse = httpclient.execute(httpMethod);
            return closeableHttpResponse;
        }
        catch (Exception e) {
            throw new Exception("Failed to send http request, Reason: " + e);
        }
        finally {
            httpclient.close();
        }
    }

    private String getAuthorizationHeaderForBasic(String userName, String password) {
        String token = userName + ":" + password;
        try {
            return "Basic " + DatatypeConverter.printBase64Binary(token.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot encode with UTF-8", ex);
        }
    }

    private void generateAccessToken() throws Exception {
        Map map = new HashMap();
        HttpPost post = new HttpPost(this.apiBaseURI + "/auth/oauth/token");
        ArrayList<BasicNameValuePair> parametersBody = new ArrayList<BasicNameValuePair>();
        parametersBody.add(new BasicNameValuePair("grant_type", "client_credentials"));
        parametersBody.add(new BasicNameValuePair("client_id", this.apiKey));
        parametersBody.add(new BasicNameValuePair("client_secret", this.apiSecret));
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient client = builder.build();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.getConnectTimeout()).setConnectionRequestTimeout(this.getConnectionRequestTimeout()).setSocketTimeout(this.getSocketTimeout()).build();
        builder.setDefaultRequestConfig(config).build();
        client = SdkUtil.wrapClient(builder);
        SdkUtil.trustSelfSignedSSL();
        CloseableHttpResponse response = null;
        String result = "";
        try {
            post.setEntity(new UrlEncodedFormEntity(parametersBody, "UTF-8"));
            response = client.execute(post);
            BufferedReader buffer = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String s = "";
            while ((s = buffer.readLine()) != null) {
                result = result + s;
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new Exception(result);
            }
            map = (Map)new Gson().fromJson(result, new TypeToken<HashMap<String, String>>(){}.getType());
            this.accessToken = (String)map.get("access_token");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static CloseableHttpClient wrapClient(HttpClientBuilder builder) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLConnectionSocketFactory ssf = new SSLConnectionSocketFactory(ctx, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", ssf).build();
            PoolingHttpClientConnectionManager ccm = new PoolingHttpClientConnectionManager(registry);
            CloseableHttpClient httpclient = builder.setConnectionManager(ccm).build();
            return httpclient;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String parseResponse(HttpResponse response) throws Exception {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 407) {
            return "access token expired";
        }
        InputStream in = response.getEntity().getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line + "");
        }
        Gson gson = new Gson();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("status", "" + statusCode);
        map1.put("status_message", sb.toString());
        return gson.toJson(map1);
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public void setApiUserName(String apiUserName) {
        this.apiUserName = apiUserName;
    }

    public void setApiPassword(String apiPassword) {
        this.apiPassword = apiPassword;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setApiBaseURI(String apiBaseURI) {
        this.apiBaseURI = apiBaseURI;
    }

    protected static void trustSelfSignedSSL() {
        try {
            TrustManager[] trustCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            SSLContext sslContext = null;
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    private static void configureObjectMapper() {
        objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public static boolean isRetryAbleException(String errorMsg) {
        return errorMsg.contains("503 Service Unavailable") || errorMsg.contains("504 Gateway Time-out");
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }
}

